#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <allegro.h>
//#include "jgmod.h"

#include "curling.h"

#include "Standards.h"
#include "CParts.h"
#include "CStones.h"
#include "CPlayer.h"

#define DEPTH      16
#define S_W        640
#define S_H        480
#define target_fps 40

#define startx  670
#define starty  218
#define screen_start_x  350
#define screen_start_y  -23

#define button_x    3681
#define button_y    219

#define hog1    745
#define hog2    3145

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define Rad2AllegroDeg  40.74366543153

void allegro_startup(void);
void move_all(void);
void draw_all(void);
void calc_fps(void);
void init_game(void);
void update_mouse_point(void);
void mouse_scroll(void);
void set_screen_for_shot(void);
void toggle(int *n);
void draw_score(BITMAP *b,int x, int y, CPlayer *p1, CPlayer *p2);
void draw_menu(void);
void move_menu(void);
int calc_score(CPlayer *p1, CPlayer *p2);
void set_end(void);
void end_end(void);

volatile int sec=0,sec2=0;
int cycles=0,cycles2=0;
float actual_seconds;
float fps;
bool menu_on=true;

void go_sec(void);
void go_sec()
	{
    sec++;
    sec2++;
	}
END_OF_FUNCTION(go_sec);

BITMAP *backgr,*display;
BITMAP *zoom, *score;
DATAFILE *data;
//JGMOD *song;

CParts pParts;
Point mouse_point;
CStones stones;
Point screen_pos={0,-23};

RGB white={255,255,255}, red={255,0,0}, blue={0,0,255};

bool quit_game=false;
bool exit_prog=false;

//float sx=0,sy=0;
float w=1,h=1 ;
bool shooting=false;
int current_shot=0; //rock currently being shot
bool has_been_shot=false;   //whether the current shot has been shot or not
int current_player=0;   //current player shooting
bool button_preview=false;
CPlayer player[2];
int end=1;            //the current end

float word_movex=0,word_movey=0;
int selected=0;
int move_dir=0;
bool close_menu=false;

int main() 
{         
   allegro_startup();
   init_game();

   //song=load_mod("2300-Aquarium.xm");
   //play_mod(song,false);

   while(exit_prog==false)
        {
        menu_on=true;
        close_menu=false;
        play_midi((MIDI*)data[title].dat,TRUE);

        while(! key[KEY_ESC] && quit_game==false)
            {

            if(cycles < sec)
                {
                if(menu_on==false)
                    {
                    draw_all();
                    move_all();
                    }
                else
                    {
                    draw_menu();
                    move_menu();
                    }
                calc_fps();
                }
            }
    }
    player[0].destroy();
    player[1].destroy();
    destroy_bitmap(backgr);
    destroy_bitmap(zoom);
    destroy_bitmap(score);
    unload_datafile(data);
    stones.destroy_all();
    //destroy_mod(song);
    return 0;
}     
END_OF_MAIN();

void move_all(void)
{
     int stones_return;
     cycles++;
     cycles2++;

    stones_return=stones.move_all(/*.9925*/0.05 , &screen_pos);
    stones.check_all_bounds(hog2);

    if(stones_return==1)    //a stone went out of bounds
        {

        }
    //updates the struct that contains the position of the mouse
    update_mouse_point();

    if(key[KEY_R])
        init_game();

    if(key[KEY_U] && w>.17 && h>.17 && shooting==false) //zoom out
        {
        w-=.01;
        h-=.01;
        screen_pos.y-=2;
        }
    else if(key[KEY_I] && w<1 && h<1 && shooting==false)     //zoom in
        {
        w+=.01;
        h+=.01;
        screen_pos.y+=2;

        screen_pos.x = mouse_point.x - 320;
        }

    //if a shot is being set up, and the mouse is not clicked, and
    //a rock hasn't already been shot we must be shooting another
    if(shooting==true && !mouse_b&1 && has_been_shot==false)
        {
         //shoots a stone, returns 1 if it was shot successfully
         if(/*stones.stone[current_shot].shoot(&mouse_point)==1*/player[current_player].shoot(&stones.stone[current_shot],&mouse_point))
            {
            //player[current_player].shooting=true;
            has_been_shot=true;
            mouse_x=320;
            mouse_y=240;
            }
        }

    if(mouse_b&1 && has_been_shot==false)  //draws a fancy zoomed in version of the button when shooting
        {
        shooting=true;
        button_preview=true;
        stones.stone[current_shot].get_shot_angle(&mouse_point);
        }
    else
        {
        shooting=false;
        button_preview=false;
        }

    if(key[KEY_P] && button_preview==true)
        button_preview=false;
    else if(key[KEY_P])
        button_preview=true;

    //is the stone has been shot, but there are no stones moving
    //the shot must already be over
    //set up for the next shot
    if(has_been_shot==true && stones.are_any_moving()==0)
        {
        if(current_shot<16)
            {
            current_shot++;   //activate next rock
            toggle(&current_player);   //toggle player that's up

            //create the appropriate coloured rock
            if(current_player==0)
                stones.create_stone(startx,starty,(BITMAP*)data[red_stone].dat,0);
            else if(current_player==1)
                stones.create_stone(startx,starty,(BITMAP*)data[yellow_stone].dat,1);

            //neither player currently has a rock moving
            player[0].not_shooting();
            player[1].not_shooting();

            }
        else
            {
            //end the end
            }

        //no rock has been shot yet
        has_been_shot=false;
        }

    //calc_score(&player[0],&player[1]);
    if(player[0].rocks_left==0 && player[1].rocks_left==0 && has_been_shot==false)
        {
         end_end();

        }

    //only allow the screen to scroll if the player is not setting up a shot
    if(shooting==false)
        mouse_scroll();
}

void draw_all(void)
{
    rectfill(backgr,0,0,S_W,S_H,0);
    rectfill(zoom,0,0,zoom->w,zoom->h,0);

    if(w==1)
        blit((BITMAP*)data[rink1].dat,backgr,(int)screen_pos.x,(int)screen_pos.y,0,0,640,480);
    else
        stretch_blit((BITMAP*)data[rink1].dat,backgr,(int)screen_pos.x,0,3898,434,0,(int)-screen_pos.y,(int)(3898*w),(int)(434*h));

    if(button_preview==true)
       {
       blit((BITMAP*)data[rink1].dat,zoom,3898-zoom->w,0,0,0,zoom->w,zoom->h);
       stones.draw_all(zoom,(3898-zoom->w),0,1,1);
       rect(zoom,0,0,zoom->w-1,zoom->h-1,0);
       }

    if(shooting==true)
        {
        set_screen_for_shot();
        //blit((BITMAP*)data[rink1].dat,zoom,3898-zoom->w,0,0,0,zoom->w,zoom->h);
        //stones.draw_all(zoom,3893-zoom->w,0,1,1);

        stones.stone[current_shot].draw_shot(backgr,zoom,screen_pos.x,screen_pos.y,&mouse_point);

        //stretch_blit(zoom,backgr,0,0,zoom->w,zoom->h,(int)(640-(zoom->w/2)),0,(int)(zoom->w/2),(int)(zoom->h/2));
        }

     if(button_preview==true)
        {
        stretch_blit(zoom,backgr,0,0,zoom->w,zoom->h,(int)(640-(zoom->w/2)),0,(int)(zoom->w/2),(int)(zoom->h/2));
        }


    textprintf(backgr,font,0,0,makecol(255,0,0),"%f",fps);
    textprintf(backgr,font,0,10,makecol(255,0,0),"%f %f %d %f %f",(rink_width*w),screen_pos.x,current_shot,stones.stone[0].move.dx,stones.stone[0].move.dy);

    if(w!=1 && h!=1)
        stones.draw_all(backgr,screen_pos.x,screen_pos.y,w,h);
    else
        stones.draw_all(backgr,screen_pos.x,screen_pos.y);

    draw_score(score,15,15,&player[0],&player[1]);

    //draws mouse pointer
    circlefill(backgr,mouse_x,mouse_y,4,makecol(0,255,0));

    blit(backgr,display,0,0,0,0,S_W,S_H);
   // blit(display,screen,0,0,0,0,S_W,S_H);
}

void calc_fps(void)
{
    actual_seconds = (float)sec/target_fps;

    fps = (float)cycles2 / ((float)sec2/target_fps);
    if(cycles2%300 == 0)
    {
        cycles2=0;
        sec2=0;
    }
}

void allegro_startup(void)
{
     allegro_init();
     install_keyboard();
     install_timer();
     install_mouse();

     set_color_depth(DEPTH);

   //  if(os_type == OSTYPE_WIN98)
   //       set_gfx_mode(GFX_DIRECTX,S_W,S_H,0,0);
   //  else
     set_gfx_mode(GFX_AUTODETECT,S_W,S_H,0,0);

     //reserve_voices(32,-1);
     if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL)<0)
     {
     exit(0);
     }

    /* if(install_mod(16)<0)
     {
     exit(0);
     }   */

     srand(time(0));

    data=load_datafile("curling.dat");   //datafile will be loaded here
    //set_pallete((RGB*)data[pal].dat);  //pal will be loaded here

    pParts.init();

    display=create_video_bitmap(SCREEN_W,SCREEN_H);
    backgr=create_video_bitmap(SCREEN_W,SCREEN_H);
    zoom=create_bitmap(800,434);
    score=create_bitmap(100,130);

	rectfill(backgr,0,0,SCREEN_W,SCREEN_H,0);

    set_trans_blender(187,197,187,187);

    text_mode(-1);

    LOCK_VARIABLE(sec);
    LOCK_FUNCTION(go_sec);
	install_int_ex(go_sec, BPS_TO_TIMER(target_fps));
}

void init_game(void)
{
    current_player=1;
    set_end();
    end=1;

    player[0].init(NULL,"ON",true);
    player[1].init(NULL,"BC",false);
}

void set_end(void)
{
    stones.init_all();

    if(current_player==0)
        stones.create_stone(startx,starty,(BITMAP*)data[red_stone].dat,0); //player 0 controlled
    else if(current_player==1)
        stones.create_stone(startx,starty,(BITMAP*)data[yellow_stone].dat,1); //player 0 controlled

    screen_pos.x=400;
    current_shot=0;
   // has_been_shot=false;
    has_been_shot==true;

    player[0].set_rocks(8);
    player[1].set_rocks(8);
}

void end_end(void)
{
    int p=calc_score(&player[0], &player[1]); //p is the player that won the end
    set_end();

    if(p==0)
        {
        current_player=0;
        player[1].set_hammer(true);
        player[0].set_hammer(false);
        }
    else if(p==1)
        {
        current_player=1;
        player[0].set_hammer(true);
        player[1].set_hammer(false);
        }
}

void update_mouse_point(void)
{
    mouse_point.x = mouse_x+screen_pos.x;
    mouse_point.y = mouse_y+screen_pos.y;

    if(mouse_point.x > startx)
        mouse_point.x = startx;
}

void mouse_scroll(void)
{
    if(mouse_x >= 639)
        screen_pos.x +=10/w;
    else if(mouse_x <=1 && screen_pos.x>3)
        screen_pos.x -=10/w;

//((pos.x-s_x)*w)

    if(screen_pos.x>rink_width-640/w)
        {
        screen_pos.x=rink_width-640/w;
        }

    if(screen_pos.x <0)
        screen_pos.x =0;

}

void set_screen_for_shot(void)
{
    screen_pos.x=screen_start_x;
    screen_pos.y=screen_start_y;
    w=1;
    h=1;
}

void toggle(int *n)
{
    if(*n==0)
        *n=1;
    else if(*n==1)
        *n=0;
}

void draw_score(BITMAP *b,int x, int y, CPlayer *p1, CPlayer *p2)
{
    int r1=8,r2=8;  //number of rocks to draw for player 1 and player 2

    rectfill(b,0,0,100,130,makecol(0,0,0));
    line(b,50,20,50,130,makecol(200,200,0));
    line(b,0,39,100,39,makecol(200,200,0));

    textprintf_centre(b,(FONT*)data[arial_8].dat,25,23,makecol(255,255,0),"%s: %d",p1->name,p1->score);
    textprintf_centre(b,(FONT*)data[arial_8].dat,75,23,makecol(255,255,0),"%s: %d",p2->name,p2->score);

    textprintf_centre(b,(FONT*)data[arial_8].dat,50,3,makecol(255,255,0),"End: %d",end);

    if(p1->has_hammer==true)
        draw_sprite(b,(BITMAP*)data[hammer].dat,8,3);
    else if(p2->has_hammer==true)
        draw_sprite(b,(BITMAP*)data[hammer].dat,78,3);

    r1=p1->rocks_left;
    r2=p2->rocks_left;

    if(cycles%12 >= 0 && cycles%12<6)
        {
        if(p1->shooting==true)
            r1=p1->rocks_left+1;
        else if(p2->shooting==true)
            r2=p2->rocks_left+1;
        }

    for(int n=0 ; n<r1 ; n++)
        {
        if(n%2 == 0)
            draw_sprite(b,(BITMAP*)data[red_stone_small].dat,5,43+((int)(n/2)*20));
        else if(n%2 == 1)
            draw_sprite(b,(BITMAP*)data[red_stone_small].dat,25,43+((int)(n/2)*20));
        }

    for(int n=0 ; n<r2 ; n++)
        {
        if(n%2 == 0)
            draw_sprite(b,(BITMAP*)data[yellow_stone_small].dat,55,43+((int)(n/2)*20));
        else if(n%2 == 1)
            draw_sprite(b,(BITMAP*)data[yellow_stone_small].dat,75,43+((int)(n/2)*20));
        }

    draw_trans_sprite(backgr,b,x,y);

}

void move_menu(void)
{
    static int counter=0;
    bool end_menu=false;
    cycles++;
    cycles2++;

    if(counter==0)
        {
        if(key[KEY_DOWN])
            selected++;
        else if(key[KEY_UP])
            selected--;

        if(key[KEY_ENTER])
            end_menu=true;

        counter=10;
        }

    if(counter>0)
        counter--;

    if(selected<0)
        selected*=-1;
    selected=selected%2;

    if(cycles%5==0)
        {
        //move_dir=rand()%8;
        move_dir++;
        move_dir=move_dir%8;
        }

    word_movex += (cos(((M_PI*2)/8)*move_dir)*2);
    word_movey += (sin(((M_PI*2)/8)*move_dir)*2);


    if(end_menu==true)
        {
        cycles=0;
        cycles2=0;
        sec=0;
        sec2=0;

        if(selected==0)     //play game
            {
            init_game();
            close_menu=true;
            play_midi((MIDI*)data[game1].dat,TRUE);
            }
        else if(selected==1)    //quit game
            {
            quit_game=true;
            exit_prog=true;
            }
        }
}

void draw_menu(void)
{
    static int mx=0;
    rectfill(backgr,0,0,S_W,S_H,0);
    blit((BITMAP*)data[menu].dat,backgr,0,0,0,0,640,480);

    if(selected==0)
        draw_sprite(backgr,(BITMAP*)data[menu_item1].dat,320-165+(int)word_movex,260+(int)word_movey);
    else
        draw_sprite(backgr,(BITMAP*)data[menu_item1].dat,320-165,260);

    if(selected==1)
        draw_sprite(backgr,(BITMAP*)data[menu_item2].dat,320-40+(int)word_movex,420+(int)word_movey);
    else
        draw_sprite(backgr,(BITMAP*)data[menu_item2].dat,320-40,420);


    if(close_menu==true)    //quitting the menu screen
        {
        mx+=5;
        if(mx>320)
            menu_on=false;

        rectfill(backgr,0,0,mx,480,0);
        rectfill(backgr,640-mx,0,640,480,0);
        }

    blit(backgr,display,0,0,0,0,S_W,S_H);
}

int calc_score(CPlayer *p1, CPlayer *p2)
{
    int owner[18],dist[18];
    int temp1,temp2;
    int house_dist=216;
    int player=-1;
    int points[2]={p1->score,p2->score};

    for(int n=0 ; n<stones.next_stone ; n++)
        {
        owner[n] = stones.stone[n].owner;
        dist[n] = (int)(get_dist((float)button_x,(float)button_y,(float)stones.stone[n].pos.x,(float)stones.stone[n].pos.y) );
        }

    for(int n=0 ; n<stones.next_stone ; n++)
        {
        for(int n2=0 ; n2<stones.next_stone-1 ; n2++)
            {
            if(dist[n2] > dist[n2+1])
                {
                temp1=owner[n2];
                temp2=dist[n2];

                owner[n2] = owner[n2+1];
                dist [n2] = dist [n2+1];

                owner[n2+1] = temp1;
                dist [n2+1] = temp2;
                }
            }
        }

    for(int n=0 ; n<stones.next_stone ; n++)
        {
        if(dist[n]<=house_dist)
            {
            if(player==-1 || player == owner[n])
                {
                player=owner[n];
                points[player]++;
                }
            else
                break;
            }
        }

    p1->score = points[0];
    p2->score = points[1];

    //return the player that gets the points
    if(points[0]!=0)
        return 0;
    else if(points[1]!=0)
        return 1;

    return -1;
}

